/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.exception.LexiconException;
import simplenlg.features.Category;
import simplenlg.features.InflectionType;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.LexicalItem;

public abstract class Word
implements LexicalItem,
Cloneable {
    String baseForm = null;
    String citationForm = null;
    String id;
    Category category;
    LexiconInterface parentLexicon = null;
    InflectionType inflectionType;

    Word() {
    }

    public Word(String baseform) {
        this();
        this.citationForm = this.baseForm = baseform;
    }

    public Word(String id, String baseform, String citationform) {
        this(baseform);
        this.id = id;
        this.citationForm = citationform;
    }

    @Deprecated
    public Word(String baseform, LexiconInterface lexicon) {
        this(baseform);
        this.parentLexicon = lexicon;
        this.parentLexicon.addItem(this);
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public boolean hasID() {
        return this.id != null;
    }

    @Override
    public String getBaseForm() {
        return this.baseForm;
    }

    @Override
    public void setCitationForm(String s) {
        this.citationForm = s;
    }

    @Override
    public String getCitationForm() {
        return this.citationForm;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setParentLexicon(LexiconInterface lex) {
        this.parentLexicon = lex;
        this.parentLexicon.addItem(this);
    }

    @Override
    public LexiconInterface getParentLexicon() {
        return this.parentLexicon;
    }

    @Override
    public boolean hasInflectionType() {
        return this.inflectionType != null;
    }

    @Override
    public InflectionType getInflectionType() {
        return this.inflectionType;
    }

    @Override
    public void setInflectionType(InflectionType inflectionType) {
        if (inflectionType == null) {
            this.inflectionType = null;
        } else if (inflectionType.appliesTo(this.category)) {
            this.inflectionType = inflectionType;
        } else {
            throw new LexiconException("InflectionType " + inflectionType + " cannot apply to Lexical Items of category " + (Object)((Object)this.category));
        }
    }

    @Override
    public boolean isDLRegular() {
        return this.inflectionType == InflectionType.REG_DOUBLING;
    }

    @Override
    public boolean isRegular() {
        return this.inflectionType == InflectionType.REGULAR;
    }

    @Override
    public boolean isGLRegular() {
        return this.inflectionType == InflectionType.GL_REGULAR;
    }

    @Override
    public boolean isInvariant() {
        return this.inflectionType == InflectionType.INVARIANT;
    }

    public boolean isPeriphrastic() {
        return this.inflectionType == InflectionType.PERIPHRASTIC;
    }

    public String toString() {
        return this.baseForm;
    }

    public Word clone() {
        try {
            return (Word)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object o) {
        try {
            Word cw = (Word)o;
            return this.baseForm.equalsIgnoreCase(cw.baseForm) && this.category == cw.category;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

