/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.lexicon.morph.MorphologicalRule;
import simplenlg.lexicon.morph.PatternActionRule;
import simplenlg.lexicon.morph.WordLists;

public class InflectionRule<T extends ContentWord>
implements MorphologicalRule<T> {
    List<PatternActionRule> patternActionRules;
    PatternActionRule defaultRule;
    String name;
    Matcher wordMatcher = Pattern.compile("^((\\w+)(-\\w+)*)(\\s((\\w+)(-\\w+)*))*$").matcher("blablabla");
    boolean doubling = false;

    public InflectionRule() {
        this.patternActionRules = new ArrayList<PatternActionRule>();
    }

    public InflectionRule(String ruleName) {
        this();
        this.setName(ruleName);
    }

    public InflectionRule(String ruleName, PatternActionRule defRule) {
        this(ruleName);
        this.setDefaultRule(defRule);
    }

    public InflectionRule(String ruleName, PatternActionRule defRule, PatternActionRule ... ruleSet) {
        this(ruleName, defRule);
        this.setExceptionRules(ruleSet);
    }

    public InflectionRule(String ruleName, boolean applyDoubling, PatternActionRule defRule, PatternActionRule ... ruleSet) {
        this(ruleName, defRule);
        this.setExceptionRules(ruleSet);
        this.setApplyDoubling(applyDoubling);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public boolean hasName() {
        return this.name != null;
    }

    public void setApplyDoubling(boolean consDoubling) {
        this.doubling = consDoubling;
    }

    public boolean appliesDoubling() {
        return this.doubling;
    }

    public void addExceptionRules(PatternActionRule ... rules) {
        this.addExceptionRules(Arrays.asList(rules));
    }

    public void addExceptionRules(Collection<PatternActionRule> rules) {
        this.patternActionRules.addAll(rules);
        Collections.sort(this.patternActionRules);
    }

    public void setExceptionRules(PatternActionRule ... actionRules) {
        this.patternActionRules.clear();
        this.addExceptionRules(actionRules);
    }

    public void setExceptionRules(Collection<PatternActionRule> actionRules) {
        this.patternActionRules.clear();
        this.addExceptionRules(actionRules);
    }

    public int getNumberOfRules() {
        return this.patternActionRules.size();
    }

    public void setDefaultRule(PatternActionRule defRule) {
        this.defaultRule = defRule;
    }

    @Override
    public String apply(T lex) {
        String result;
        String base = "";
        base = lex instanceof Verb ? ((Verb)lex).getBaseform(false) : ((Word)lex).getBaseForm();
        if (!((Word)lex).hasInflectionType()) {
            return this.apply(base);
        }
        switch (((Word)lex).getInflectionType()) {
            case INVARIANT: 
            case PERIPHRASTIC: {
                result = base;
                break;
            }
            case REGULAR: {
                result = this.defaultRule.fire(base);
                break;
            }
            case REG_DOUBLING: {
                if (this.doubling) {
                    result = this.defaultRule.fire(this.doubleFinalConsonant(base));
                    break;
                }
                result = this.defaultRule.fire(base);
                break;
            }
            default: {
                result = this.apply(base);
            }
        }
        return result;
    }

    @Override
    public String apply(String word) {
        this.wordMatcher.reset(word);
        if (!this.wordMatcher.matches()) {
            return word;
        }
        if (WordLists.MODALS.contains(word)) {
            return word;
        }
        String result = null;
        for (PatternActionRule currentRule : this.patternActionRules) {
            if (!currentRule.applies(word)) continue;
            result = currentRule.fire(word);
            break;
        }
        if (result == null && this.defaultRule != null) {
            if (this.doubling && WordLists.VERB_CONS_DOUBLING.contains(word)) {
                word = this.doubleFinalConsonant(word);
            }
            result = this.defaultRule.fire(word);
        }
        return result;
    }

    private String doubleFinalConsonant(String word) {
        StringBuffer buffer = new StringBuffer(word);
        buffer.append(buffer.charAt(buffer.length() - 1));
        return buffer.toString();
    }
}

