/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;

public enum DocStructure {
    PHRASE,
    PHRASESET,
    SENTENCE,
    SENTENCESET,
    PARAGRAPH,
    PARAGRAPHSET,
    DOCUMENT;


    public boolean isSentence() {
        return this == SENTENCE;
    }

    public boolean isParagraph() {
        return this == PARAGRAPH;
    }

    public boolean isSentenceOrLower() {
        return this.compareTo(SENTENCE) <= 0;
    }

    public boolean isSentenceComponent() {
        return this.compareTo(SENTENCE) < 0;
    }

    public DocStructure max(DocStructure d2) {
        if (this.compareTo(d2) > 0) {
            return this;
        }
        return d2;
    }

    public boolean greaterThan(DocStructure d2) {
        return this.compareTo(d2) > 0;
    }

    public DocStructure next() {
        switch (this) {
            case PHRASE: {
                return PHRASESET;
            }
            case PHRASESET: {
                return SENTENCE;
            }
            case SENTENCE: {
                return SENTENCESET;
            }
            case SENTENCESET: {
                return PARAGRAPH;
            }
            case PARAGRAPH: {
                return PARAGRAPHSET;
            }
            case PARAGRAPHSET: {
                return DOCUMENT;
            }
            case DOCUMENT: {
                return DOCUMENT;
            }
        }
        return DOCUMENT;
    }

    public DocStructure previous() {
        switch (this) {
            case PHRASE: {
                return PHRASE;
            }
            case PHRASESET: {
                return PHRASE;
            }
            case SENTENCE: {
                return PHRASESET;
            }
            case SENTENCESET: {
                return SENTENCE;
            }
            case PARAGRAPH: {
                return SENTENCESET;
            }
            case PARAGRAPHSET: {
                return PARAGRAPH;
            }
            case DOCUMENT: {
                return PARAGRAPHSET;
            }
        }
        return PHRASE;
    }

    public DocStructure toSet() {
        switch (this) {
            case PHRASE: {
                return PHRASESET;
            }
            case PHRASESET: {
                return PHRASESET;
            }
            case SENTENCE: {
                return SENTENCESET;
            }
            case SENTENCESET: {
                return SENTENCESET;
            }
            case PARAGRAPH: {
                return PARAGRAPHSET;
            }
            case PARAGRAPHSET: {
                return PARAGRAPHSET;
            }
            case DOCUMENT: {
                return DOCUMENT;
            }
        }
        return DOCUMENT;
    }

    public String getName() {
        switch (this) {
            case PHRASE: {
                return "PHRASE";
            }
            case PHRASESET: {
                return "PHRASESET";
            }
            case SENTENCE: {
                return "CLAUSE";
            }
            case SENTENCESET: {
                return "SENTENCESET";
            }
            case PARAGRAPH: {
                return "PARAGRAPH";
            }
            case PARAGRAPHSET: {
                return "PARAGRAPH";
            }
            case DOCUMENT: {
                return "DOCUMENT";
            }
        }
        throw new SimplenlgException("Unknown document structure: " + (Object)((Object)this));
    }

    public static DocStructure getStructure(String name) {
        if (name.equalsIgnoreCase("PHRASE")) {
            return PHRASE;
        }
        if (name.equalsIgnoreCase("PHRASESET")) {
            return PHRASESET;
        }
        if (name.equalsIgnoreCase("CLAUSE")) {
            return SENTENCE;
        }
        if (name.equalsIgnoreCase("SENTENCESET")) {
            return SENTENCESET;
        }
        if (name.equalsIgnoreCase("PARAGRAPH")) {
            return PARAGRAPH;
        }
        if (name.equalsIgnoreCase("PARAGRAPH")) {
            return PARAGRAPH;
        }
        if (name.equalsIgnoreCase("DOCUMENT")) {
            return DOCUMENT;
        }
        throw new SimplenlgException("Unknown document structure: " + name);
    }
}

