/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.TextSpec;

public abstract class HeadedPhraseSpec<T extends LexicalItem>
extends PhraseSpec {
    T head = null;
    List<Phrase> complements = new ArrayList<Phrase>();
    List<Phrase> premodifiers = new ArrayList<Phrase>();
    List<Phrase> postmodifiers = new ArrayList<Phrase>();
    Comparator<Phrase> complementComparator;
    Comparator<Phrase> premodifierComparator;
    Comparator<Phrase> postmodifierComparator;

    public HeadedPhraseSpec() {
        this.category = null;
        this.complementComparator = null;
        this.premodifierComparator = null;
        this.postmodifierComparator = null;
    }

    public HeadedPhraseSpec(T head) {
        this();
        this.head = head;
    }

    public T getHead() {
        return this.head;
    }

    public void setHead(T head) {
        this.head = head;
    }

    public String getHeadAsString() {
        return this.head == null ? null : this.head.getBaseForm();
    }

    public void setComplementOrder(Comparator<Phrase> comp) {
        this.complementComparator = comp;
    }

    public void setPremodifierOrder(Comparator<Phrase> comp) {
        this.premodifierComparator = comp;
    }

    public void setPostmodifierOrder(Comparator<Phrase> comp) {
        this.postmodifierComparator = comp;
    }

    public void setComplement(Object comp) {
        this.complements.clear();
        this.addComplement(comp);
    }

    public void addComplement(Object comp) {
        Phrase complement = this.makeConstituent(comp, DiscourseFunction.OBJECT);
        this.complements.add(complement);
    }

    public void setPremodifier(Object mod) {
        this.premodifiers.clear();
        this.addPremodifier(mod);
    }

    public void addPremodifier(Object mod) {
        this.premodifiers.add(this.makeConstituent(mod, DiscourseFunction.MODIFIER));
    }

    public void setPostmodifier(Object mod) {
        this.postmodifiers.clear();
        this.addPostmodifier(mod);
    }

    public void addPostmodifier(Object mod) {
        this.postmodifiers.add(this.makeConstituent(mod, DiscourseFunction.MODIFIER));
    }

    public boolean hasComplements() {
        return !this.complements.isEmpty();
    }

    public boolean hasPremodifiers() {
        return !this.premodifiers.isEmpty();
    }

    public boolean hasPostmodifiers() {
        return !this.postmodifiers.isEmpty();
    }

    public List<Phrase> getComplements() {
        return this.complements;
    }

    public List<Phrase> getPremodifiers() {
        return this.premodifiers;
    }

    public List<Phrase> getPostmodifiers() {
        return this.postmodifiers;
    }

    public void addModifier(Object modifier) {
        if (modifier instanceof String) {
            if (!((String)modifier).contains(" ")) {
                this.addPremodifier(modifier);
            } else {
                this.addPostmodifier(modifier);
            }
        } else {
            this.addPostmodifier(modifier);
        }
    }

    public boolean hasHead() {
        return this.head != null;
    }

    @Override
    public TextSpec promote(DocStructure level) {
        return new TextSpec(new Object[]{level, this});
    }

    public boolean equals(Object o) {
        try {
            HeadedPhraseSpec hps = (HeadedPhraseSpec)o;
            return this.sameHead(hps) && hps.premodifiers.equals(this.premodifiers) && hps.complements.equals(this.complements) && hps.postmodifiers.equals(this.postmodifiers);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    String realise(Realiser r) {
        return r.appendSpace(this.realisePremodifier(r), this.realiseHead(r), this.realiseComplement(r), this.realisePostmodifier(r));
    }

    String realisePremodifier(Realiser r) {
        if (this.premodifierComparator != null) {
            Collections.sort(this.premodifiers, this.premodifierComparator);
        }
        return r.realiseList(this.premodifiers);
    }

    String realisePostmodifier(Realiser r) {
        if (this.postmodifierComparator != null) {
            Collections.sort(this.postmodifiers, this.postmodifierComparator);
        }
        return r.realiseList(this.postmodifiers);
    }

    String realiseComplement(Realiser r) {
        return r.realiseAndList(this.complements);
    }

    String realiseHead(Realiser r) {
        return this.head.getBaseForm();
    }

    void clearComplements() {
        this.complements.clear();
    }

    boolean sameHead(HeadedPhraseSpec<?> hps) {
        if (this.head == hps.head) {
            return true;
        }
        if (this.head == null || hps.head == null) {
            return false;
        }
        return this.head.equals(hps.head);
    }

    abstract void setHead(String var1);
}

