/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.realiser.AdjPhraseSpec;
import simplenlg.realiser.CoordinateNPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;

public class NPPhraseSpec
extends HeadedPhraseSpec<Noun> {
    Person person;
    NumberAgr number;
    Gender gender;
    Object specifier;
    Pronoun pronoun;
    String pronounForm;
    boolean elided = false;
    boolean treatAsPlural = false;
    boolean pronominal = false;
    boolean possessive = false;
    boolean raised = false;

    public NPPhraseSpec() {
        this.head = new Noun("");
        this.specifier = new Determiner("");
        this.category = Category.NOUN;
        this.function = DiscourseFunction.NULL;
        this.number = NumberAgr.SINGULAR;
        this.person = Person.THIRD;
        this.gender = Gender.NEUTER;
        this.pronoun = null;
        this.specifier = null;
    }

    public NPPhraseSpec(String noun) {
        this();
        this.setHead(noun);
    }

    public NPPhraseSpec(String spec, String noun) {
        this(noun);
        if (!this.setSpecifier(spec)) {
            throw new SimplenlgException("Cannot set the specifier supplied to constructor.");
        }
    }

    public NPPhraseSpec(Object spec, Noun noun) {
        this();
        this.setHead(noun);
        if (!this.setSpecifier(spec)) {
            throw new SimplenlgException("Cannot set the specifier supplied to constructor.");
        }
    }

    public NPPhraseSpec(Noun noun) {
        this();
        this.setHead(noun);
    }

    @Override
    public void addModifier(Object mod) {
        if (mod instanceof AdjPhraseSpec) {
            this.addPremodifier(mod);
        } else if (mod instanceof PPPhraseSpec) {
            this.addPostmodifier(mod);
        } else {
            super.addModifier(mod);
        }
    }

    public boolean setSpecifier(Object spec) {
        if (spec == null) {
            this.specifier = spec;
            return true;
        }
        if (spec instanceof String) {
            this.specifier = Constants.getDeterminer((String)spec);
            if (this.specifier != null) {
                return true;
            }
        } else if (spec instanceof Determiner) {
            this.specifier = spec;
            return true;
        }
        try {
            this.specifier = this.makeConstituent(spec, null);
            return true;
        }
        catch (SimplenlgException se) {
            return false;
        }
    }

    public void setDeterminer(Object spec) {
        this.setSpecifier(spec);
    }

    public Object getSpecifier() {
        return this.specifier;
    }

    public boolean hasSpecifier() {
        return this.specifier != null;
    }

    @Override
    public void setHead(String n) {
        Pronoun p = Constants.getPronoun(n);
        if (p != null) {
            this.setHead(p);
        } else {
            this.setHead(new Noun(n));
        }
    }

    @Override
    public void setHead(Noun n) {
        if (n instanceof Pronoun) {
            this.setPronoun((Pronoun)n);
            this.pronominal = true;
        } else {
            this.head = n;
        }
    }

    public void setElided(boolean elided) {
        this.elided = elided;
    }

    public void setPlural(boolean plur) {
        this.number = plur ? NumberAgr.PLURAL : NumberAgr.SINGULAR;
    }

    public void setNumber(NumberAgr num) {
        this.number = num;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public void setPerson(Person p) {
        this.person = p;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setGender(Gender g) {
        this.gender = g;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setPronoun(String pro) {
        this.pronoun = Constants.getPronoun(pro);
        if (this.pronoun == null) {
            this.pronoun = new Pronoun(pro);
        }
    }

    public void setPronoun(Pronoun pro) {
        this.pronoun = pro;
    }

    public Pronoun getPronoun() {
        if (this.pronoun != null) {
            return this.pronoun;
        }
        if (this.possessive) {
            return Constants.getPossessivePronoun(this.person, this.number, this.gender);
        }
        return Constants.getPersonalPronoun(this.person, this.number, this.gender);
    }

    public String getPronounAsString() {
        return this.getPronoun().getBaseForm();
    }

    public void setPronominal(boolean pro) {
        this.pronominal = pro;
    }

    public boolean isPronominal() {
        return this.pronominal;
    }

    public boolean isPlural() {
        return this.number.equals(NumberAgr.PLURAL) || this.treatAsPlural;
    }

    public void setTreatAsPlural(boolean treatAsPlural) {
        this.treatAsPlural = treatAsPlural;
    }

    public void setPossessive(boolean poss) {
        this.possessive = poss;
    }

    public boolean isPossessive() {
        return this.possessive;
    }

    public boolean isExpletive() {
        if (this.pronominal && this.pronoun != null) {
            return this.getPronoun().isExpletive();
        }
        return false;
    }

    public NPPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateNPPhraseSpec coord = new CoordinateNPPhraseSpec(this);
        try {
            Phrase[] phraseArray = coords;
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Phrase p = phraseArray[n2];
                coord.addCoordinates((NPPhraseSpec)p);
                ++n2;
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NPPhraseSpec && super.equals(o)) {
            NPPhraseSpec np = (NPPhraseSpec)o;
            if (np.hasSpecifier()) {
                if (this.hasSpecifier()) {
                    return np.specifier.equals(this.specifier);
                }
                return false;
            }
            return !this.hasSpecifier();
        }
        return false;
    }

    @Override
    String realise(Realiser r) {
        this.checkPluralDetFeatures();
        if (this.elided) {
            return "";
        }
        if (this.pronominal) {
            this.checkPronounHeadFeatures();
            return this.pronounForm;
        }
        String realisation = super.realise(r);
        realisation = r.appendSpace(this.realiseSpec(r, realisation), realisation);
        return this.possessive ? String.valueOf(realisation) + "'s" : realisation;
    }

    String realiseSpec(Realiser r, String agreementString) {
        if (this.specifier == null || this.isPronominal()) {
            return "";
        }
        if (this.specifier instanceof Determiner) {
            if (agreementString.length() > 0) {
                return ((Determiner)this.specifier).getForm(agreementString);
            }
            return ((Determiner)this.specifier).getBaseForm();
        }
        if (this.specifier instanceof Pronoun) {
            return ((Pronoun)this.specifier).getBaseForm();
        }
        return ((PhraseSpec)this.specifier).realise(r);
    }

    @Override
    String realiseHead(Realiser r) {
        return this.isPlural() ? ((Noun)this.head).getPlural() : ((Noun)this.head).getBaseForm();
    }

    void setRaised(boolean raise) {
        this.raised = raise;
    }

    void checkPronounHeadFeatures() {
        Pronoun pro;
        Case functionCase;
        if (this.isExpletive()) {
            this.pronounForm = this.pronoun.getBaseForm();
            return;
        }
        Case pronounCase = Case.NOMINATIVE;
        Case case_ = functionCase = this.raised ? Case.NOMINATIVE : this.function.getCaseValue();
        if (functionCase == null) {
            functionCase = Case.NOMINATIVE;
        }
        if (this.pronoun != null) {
            this.number = this.pronoun.getNumber();
            this.gender = this.pronoun.getGender();
            this.person = this.pronoun.getPerson();
            pronounCase = this.pronoun.getCaseValue();
        }
        if (functionCase != pronounCase) {
            pronounCase = functionCase;
        }
        if ((pro = Constants.getPronoun(this.person, this.number, this.gender, pronounCase, this.possessive)) == null) {
            System.err.println("NULL PRO: " + this.pronoun + " " + this.person + " " + this.number + " " + this.gender + " " + pronounCase + " " + this.possessive);
        }
        this.pronounForm = pro.getBaseForm();
    }

    void checkPluralDetFeatures() {
        if (this.number.equals(NumberAgr.PLURAL) && this.specifier instanceof Determiner && ((Determiner)this.specifier).equals(Constants.INDEFINITE_SG)) {
            this.specifier = Constants.INDEFINITE_PL;
        }
    }
}

