/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.realiser.CoordinatePPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.Phrase;

public class PPPhraseSpec
extends HeadedPhraseSpec<Preposition> {
    public PPPhraseSpec() {
        this.category = Category.PREPOSITION;
    }

    public PPPhraseSpec(String preposition) {
        this();
        this.head = new Preposition(preposition);
    }

    public PPPhraseSpec(Preposition prep) {
        this();
        this.head = prep;
    }

    public PPPhraseSpec(String preposition, Object comp) {
        this(preposition);
        this.setComplement(comp);
    }

    public PPPhraseSpec(Preposition prep, Phrase comp) {
        this.head = prep;
        this.setComplement(comp);
    }

    @Override
    public void setHead(String h) {
        this.head = Constants.getPreposition(h);
        if (this.head == null) {
            this.head = new Preposition(h);
        }
    }

    @Override
    public void addComplement(Object comp) {
        Phrase complement = this.makeConstituent(comp, DiscourseFunction.PREP_OBJECT);
        this.complements.add(complement);
    }

    public PPPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinatePPPhraseSpec coord = new CoordinatePPPhraseSpec(this);
        try {
            Phrase[] phraseArray = coords;
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Phrase p = phraseArray[n2];
                coord.addCoordinates((PPPhraseSpec)p);
                ++n2;
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }
}

