/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.List;
import simplenlg.exception.SimplenlgException;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.Spec;
import simplenlg.realiser.StringPhraseSpec;

public class TextSpec
extends Spec {
    private List<Spec> children = new ArrayList<Spec>();
    private DocStructure docStructure = DocStructure.SENTENCE;
    private String listConjunct = null;

    public TextSpec() {
    }

    public TextSpec(Object ... specs) {
        this();
        Object[] objectArray = specs;
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            Object spec = objectArray[n2];
            if (spec instanceof DocStructure) {
                this.setDocStructure((DocStructure)((Object)spec));
            } else {
                this.addSpec(spec);
            }
            ++n2;
        }
    }

    public void setDocStructure(DocStructure docStructure) {
        this.docStructure = docStructure;
    }

    public DocStructure getDocStructure() {
        return this.docStructure;
    }

    public void setSentence() {
        this.setDocStructure(DocStructure.SENTENCE);
    }

    public void setParagraph() {
        this.setDocStructure(DocStructure.PARAGRAPH);
    }

    public void setDocument() {
        this.setDocStructure(DocStructure.DOCUMENT);
    }

    public void setListConjunct(String listConjunct) {
        this.listConjunct = listConjunct;
    }

    public String getListConjunct() {
        return this.listConjunct;
    }

    public List<Spec> getChildren() {
        return this.children;
    }

    public void setChildren(List<Spec> children) {
        this.children = children;
    }

    public void addChild(Object spec) {
        this.addSpec(spec);
    }

    public void addSpec(Object spec) {
        if (spec instanceof Spec) {
            ((Spec)spec).setParentSpec(this);
            this.children.add((Spec)spec);
        } else if (spec instanceof String) {
            StringPhraseSpec child = new StringPhraseSpec((String)spec);
            child.setParentSpec(this);
            this.children.add(child);
        } else {
            throw new SimplenlgException("addSpec: spec must be a PhraseSpec, TextSpec, or String");
        }
    }

    @Override
    public String realise(Realiser r) {
        this.docStructure = this.docStructure.max(this.maxDSChildren().toSet());
        List<Spec> promotedChildren = this.children;
        if (!this.docStructure.isSentenceOrLower()) {
            promotedChildren = new ArrayList<Spec>();
            for (Spec child : this.children) {
                promotedChildren.add(child.promote(DocStructure.SENTENCE));
            }
        }
        String result = "";
        result = this.listConjunct != null ? r.realiseConjunctList(promotedChildren, this.listConjunct) : (this.docStructure.isSentenceOrLower() ? (!this.hasCuePhrase() ? r.realiseAndList(promotedChildren) : r.realiseConjunctList(promotedChildren, ",")) : r.realiseList(promotedChildren));
        if (this.docStructure.isSentence()) {
            result = r.applySentenceOrthography(result);
        }
        if (this.docStructure.isParagraph()) {
            result = r.applyParagraphOrthography(result);
        }
        return result;
    }

    public int size() {
        return this.children.size();
    }

    private boolean hasCuePhrase() {
        for (Spec spec : this.children) {
            if (spec instanceof SPhraseSpec && ((SPhraseSpec)spec).hasCuePhrase()) {
                return true;
            }
            if (!(spec instanceof TextSpec) || !((TextSpec)spec).hasCuePhrase()) continue;
            return true;
        }
        return false;
    }

    private DocStructure maxDSChildren() {
        DocStructure maxDSvalue = DocStructure.PHRASE;
        for (Spec child : this.children) {
            if (!(child instanceof TextSpec)) continue;
            maxDSvalue = maxDSvalue.max(((TextSpec)child).maxDS());
        }
        return maxDSvalue;
    }

    private DocStructure maxDS() {
        return this.getDocStructure().max(this.maxDSChildren());
    }

    @Override
    public TextSpec promote(DocStructure level) {
        if (this.docStructure.compareTo(level) >= 0) {
            return this;
        }
        TextSpec newts = new TextSpec(new Object[]{this.docStructure.next(), this});
        return newts.promote(level);
    }

    public String toString() {
        return this.toString("", new Realiser());
    }

    private String toString(String indent, Realiser r) {
        String result = String.valueOf(indent) + (Object)((Object)this.docStructure) + ": ";
        result = this.listConjunct != null ? String.valueOf(result) + "TextSpec-List " + this.listConjunct : String.valueOf(result) + "TextSpec";
        if (this.children.size() == 1 && !(this.children.get(0) instanceof TextSpec)) {
            result = String.valueOf(result) + " -- " + r.realise(this.children.get(0)) + "\n";
        } else {
            result = String.valueOf(result) + "\n";
            for (Spec child : this.children) {
                result = child instanceof TextSpec ? String.valueOf(result) + ((TextSpec)child).toString(String.valueOf(indent) + "+", r) : String.valueOf(result) + indent + "+" + r.realise(child) + "\n";
            }
        }
        return result;
    }
}

