/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import simplenlg.exception.SimplenlgException;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;

public class VPPhraseSpec
extends HeadedPhraseSpec<Verb> {
    boolean perfect;
    boolean progressive;
    boolean passive;
    boolean negated;
    boolean realiseAuxiliary;
    String modal;
    Tense tense;
    Person person;
    NumberAgr number;
    Form form;
    String auxiliaryRealisation;
    String mainVerbRealisation;
    Stack<String> vgComponents;
    boolean suppressObject;
    boolean suppressIndirectObject;

    public VPPhraseSpec() {
        this.category = Category.VERB;
        this.perfect = false;
        this.progressive = false;
        this.passive = false;
        this.negated = false;
        this.modal = null;
        this.tense = Tense.PRESENT;
        this.person = Person.THIRD;
        this.number = NumberAgr.SINGULAR;
        this.form = Form.NORMAL;
        this.head = new Verb("");
        this.realiseAuxiliary = true;
        this.complementComparator = new VerbObjectComparator();
        this.auxiliaryRealisation = "";
        this.mainVerbRealisation = "";
        this.vgComponents = new Stack();
        this.suppressObject = false;
        this.suppressIndirectObject = false;
    }

    public VPPhraseSpec(String v) {
        this();
        this.setHead(v);
    }

    public VPPhraseSpec(Verb v) {
        this();
        this.setHead(v);
    }

    @Override
    public void setHead(String v) {
        this.head = this.castToVerb(v);
    }

    @Override
    public void addComplement(Object comp) {
        this.addComplement(comp, DiscourseFunction.OBJECT);
    }

    public void addComplement(Object comp, DiscourseFunction function) {
        if (function.equals(DiscourseFunction.MODIFIER) || function.equals(DiscourseFunction.SUBJECT) || function.equals(DiscourseFunction.PREP_OBJECT)) {
            throw new SimplenlgException("Complements of a verb phrase can only be assigned the functionsOBJECT, INDIRECT_OBJECT");
        }
        this.complements.add(this.makeConstituent(comp, function));
    }

    public void setComplement(Object comp, DiscourseFunction function) {
        this.complements.removeAll(this.getComplements(function));
        this.addComplement(comp, function);
    }

    public void setForm(Form f) {
        this.form = f;
        if (this.form == Form.GERUND || this.form == Form.INFINITIVE || this.form == Form.BARE_INFINITIVE) {
            this.tense = Tense.PRESENT;
        }
    }

    public Form getForm() {
        return this.form;
    }

    public void setPassive(boolean pass) {
        this.passive = pass;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setProgressive(boolean prog) {
        this.progressive = prog;
    }

    public boolean isProgressive() {
        return this.progressive;
    }

    public void setPerfect(boolean perf) {
        this.perfect = perf;
    }

    public boolean isPerfect() {
        return this.perfect;
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public void setTense(Tense t) {
        this.tense = t;
    }

    public Tense getTense() {
        return this.tense;
    }

    public String getModal() {
        return this.modal;
    }

    public void setModal(String modal) {
        this.modal = modal;
    }

    public void setPerson(Person p) {
        this.person = p;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setNumber(NumberAgr n) {
        this.number = n;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public void setParticle(String particle) {
        ((Verb)this.head).setParticle(particle);
    }

    public List<Phrase> getComplements(DiscourseFunction func) {
        ArrayList<Phrase> compsToReturn = new ArrayList<Phrase>();
        for (Phrase p : this.complements) {
            if (p.getDiscourseFunction() != func) continue;
            compsToReturn.add(p);
        }
        return compsToReturn;
    }

    List<Phrase> getPassiveRaisingComplements() {
        List<Phrase> objects = this.getComplements(DiscourseFunction.OBJECT);
        if (objects.isEmpty()) {
            for (Phrase p : this.getComplements(DiscourseFunction.INDIRECT_OBJECT)) {
                if (p instanceof PPPhraseSpec) {
                    objects.addAll(((PPPhraseSpec)p).getComplements());
                    continue;
                }
                objects.add(p);
            }
        }
        return this.flagRaisedNPs(objects, true);
    }

    public boolean hasSameFeatures(VPPhraseSpec vp) {
        return this.passive == vp.passive && this.perfect == vp.perfect && this.negated == vp.negated && this.progressive == vp.progressive && this.person == vp.person && this.number == vp.number;
    }

    public VPPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateVPPhraseSpec coord = new CoordinateVPPhraseSpec(this);
        try {
            Phrase[] phraseArray = coords;
            int n = coords.length;
            int n2 = 0;
            while (n2 < n) {
                Phrase p = phraseArray[n2];
                coord.addCoordinates((VPPhraseSpec)p);
                ++n2;
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    public void realiseAuxiliary(boolean aux) {
        this.realiseAuxiliary = aux;
    }

    String realise(Realiser r, boolean interrogative) {
        this.realiseVerbGroup(r, interrogative);
        this.computeRealisation(r, interrogative);
        String preMod = this.realisePremodifier(r);
        String comp = this.realiseComplement(r);
        String postMod = this.realisePostmodifier(r);
        if (this.realiseAuxiliary) {
            return r.appendSpace(this.auxiliaryRealisation, preMod, this.mainVerbRealisation, comp, postMod);
        }
        return r.appendSpace(preMod, this.mainVerbRealisation, comp, postMod);
    }

    @Override
    String realise(Realiser r) {
        return this.realise(r, false);
    }

    String getInterrogativeFrontedElement(LexiconInterface lex) {
        if (this.vgComponents.size() == 1 && !((Verb)this.head).isCopular()) {
            return lex.getVerbForm("do", this.tense, this.person, this.number);
        }
        if (!this.vgComponents.empty()) {
            return this.vgComponents.peek();
        }
        return null;
    }

    void computeRealisation(Realiser r, boolean interrogative) {
        this.mainVerbRealisation = "";
        this.auxiliaryRealisation = "";
        boolean mainVerbSeen = false;
        String omit = null;
        if (interrogative) {
            omit = this.getInterrogativeFrontedElement(r.getLexicon());
        }
        for (String word : this.vgComponents) {
            boolean skip;
            boolean bl = skip = omit != null && word.equals(omit);
            if (!mainVerbSeen) {
                if (!skip) {
                    this.mainVerbRealisation = r.appendSpace(word, this.mainVerbRealisation);
                }
                if (word.equalsIgnoreCase("not")) continue;
                mainVerbSeen = true;
                continue;
            }
            if (skip) continue;
            this.auxiliaryRealisation = r.appendSpace(word, this.auxiliaryRealisation);
        }
    }

    void realiseVerbGroup(Realiser r, boolean interrogative) {
        this.vgComponents.clear();
        LexiconInterface lex = r.getLexicon();
        boolean modalPast = false;
        String actualModal = null;
        if (this.form == Form.INFINITIVE) {
            actualModal = "to";
        } else if (this.form.allowsTense()) {
            if (this.tense.equals(Tense.FUTURE) && this.modal == null) {
                actualModal = "will";
            } else if (this.modal != null) {
                actualModal = this.modal;
                if (this.tense.equals(Tense.PAST)) {
                    modalPast = true;
                }
            }
        }
        Verb frontVG = (Verb)this.head;
        if (this.passive) {
            this.vgComponents.push(frontVG.getPastParticiple());
            frontVG = (Verb)lex.getItem(Category.VERB, "be");
        }
        if (this.progressive) {
            this.vgComponents.push(frontVG.getPresentParticiple());
            frontVG = (Verb)lex.getItem(Category.VERB, "be");
        }
        if (this.perfect || modalPast) {
            this.vgComponents.push(frontVG.getPastParticiple());
            frontVG = (Verb)lex.getItem(Category.VERB, "have");
        }
        if (actualModal != null) {
            this.vgComponents.push(frontVG.getBaseForm());
            frontVG = null;
        }
        if (this.negated) {
            if (!this.vgComponents.empty() || frontVG != null && frontVG.isCopular()) {
                this.vgComponents.push("not");
            } else {
                if (frontVG != null) {
                    this.vgComponents.push(frontVG.getBaseForm());
                }
                this.vgComponents.push("not");
                frontVG = (Verb)lex.getItem(Category.VERB, "do");
            }
        }
        if (frontVG != null) {
            if (this.form == Form.GERUND) {
                this.vgComponents.push(frontVG.getPresentParticiple());
            } else if (!this.form.allowsTense() || interrogative && !((Verb)this.head).isCopular() && this.vgComponents.isEmpty()) {
                this.vgComponents.push(frontVG.getBaseForm());
            } else {
                this.vgComponents.push(lex.getVerbForm(frontVG.getBaseForm(), this.tense, this.person, this.number));
            }
        }
        if (actualModal != null) {
            this.vgComponents.push(actualModal);
        }
    }

    @Override
    String realiseComplement(Realiser r) {
        ArrayList complementsToRealise = new ArrayList(this.complements);
        if (this.passive) {
            complementsToRealise.removeAll(this.getPassiveRaisingComplements());
        }
        ArrayList<Phrase> objectsToRealise = new ArrayList<Phrase>();
        ArrayList<Phrase> indirectObjectsToRealise = new ArrayList<Phrase>();
        ArrayList<Phrase> otherComplementsToRealise = new ArrayList<Phrase>();
        for (Phrase p : complementsToRealise) {
            if (p.getDiscourseFunction().equals(DiscourseFunction.OBJECT)) {
                objectsToRealise.add(p);
                continue;
            }
            if (p.getDiscourseFunction().equals(DiscourseFunction.INDIRECT_OBJECT)) {
                indirectObjectsToRealise.add(p);
                continue;
            }
            otherComplementsToRealise.add(p);
        }
        Collections.sort(objectsToRealise, this.complementComparator);
        Collections.sort(indirectObjectsToRealise, this.complementComparator);
        Collections.sort(otherComplementsToRealise, this.complementComparator);
        String text = "";
        if (!this.suppressIndirectObject) {
            text = r.appendSpace(text, r.realiseAndList(indirectObjectsToRealise));
        }
        if (!this.suppressObject) {
            text = r.appendSpace(text, r.realiseAndList(objectsToRealise));
        }
        text = r.appendSpace(text, r.realiseAndList(otherComplementsToRealise));
        return text;
    }

    void suppressArg(DiscourseFunction function) {
        if (function.equals(DiscourseFunction.OBJECT)) {
            this.suppressObject = true;
        } else if (function.equals(DiscourseFunction.INDIRECT_OBJECT)) {
            this.suppressIndirectObject = true;
        }
    }

    void initialiseArgs() {
        this.suppressIndirectObject = false;
        this.suppressObject = false;
        this.flagRaisedNPs(this.complements, false);
    }

    boolean isBeVerb(String verb) {
        return verb.equalsIgnoreCase("be") || verb.equalsIgnoreCase("am") || verb.equalsIgnoreCase("are") || verb.equalsIgnoreCase("is") || verb.equalsIgnoreCase("was") || verb.equalsIgnoreCase("were");
    }

    Verb castToVerb(String verb) {
        Verb v = this.isBeVerb(verb) ? new Verb("be") : new Verb(verb);
        return v;
    }

    List<Phrase> flagRaisedNPs(List<Phrase> flagged, boolean raise) {
        for (Phrase p : flagged) {
            if (!(p instanceof NPPhraseSpec)) continue;
            ((NPPhraseSpec)p).setRaised(raise);
        }
        return flagged;
    }

    class VerbObjectComparator
    implements Comparator<Phrase> {
        VerbObjectComparator() {
        }

        @Override
        public int compare(Phrase p1, Phrase p2) {
            Category c1 = p1.getCategory();
            Category c2 = p2.getCategory();
            DiscourseFunction f1 = p1.getDiscourseFunction();
            DiscourseFunction f2 = p2.getDiscourseFunction();
            if (c1 == c2 && f1 == f2) {
                return 0;
            }
            if (c1 == c2) {
                return this.compareFunction(f1, f2);
            }
            if (c1 == Category.CLAUSE) {
                return 1;
            }
            if (c2 == Category.CLAUSE) {
                return -1;
            }
            if (c1 == Category.NOUN && c2 == Category.PREPOSITION) {
                return -1;
            }
            if (c1 == Category.PREPOSITION && c2 == Category.NOUN) {
                return 1;
            }
            return 0;
        }

        private int compareFunction(DiscourseFunction f1, DiscourseFunction f2) {
            if (f1 == null) {
                return 1;
            }
            if (f2 == null) {
                return -1;
            }
            if (f1 == f2) {
                return 0;
            }
            switch (f1) {
                case OBJECT: {
                    if (f2.equals(DiscourseFunction.INDIRECT_OBJECT)) {
                        return 1;
                    }
                    return 0;
                }
                case INDIRECT_OBJECT: {
                    return -1;
                }
            }
            return 0;
        }
    }
}

